### 10.1.1. Maven安装

Spring Boot兼容Apache Maven 3.2或更高版本。如果没有安装Maven，你可以参考[maven.apache.org](http://maven.apache.org/)指南。

**注**：在很多操作系统上，你可以通过一个包管理器安装Maven。如果你是一个OSX Homebrew用户，可以尝试`brew install maven`。Ubuntu用户可以运行`sudo apt-get install maven`。

Spring Boot依赖的groupId为`org.springframework.boot`。通常你的Maven POM文件需要继承`spring-boot-starter-parent`，然后声明一个或多个[“Starter POMs”](../III. Using Spring Boot/13.4. Starter POMs.md)依赖。Spring Boot也提供了一个用于创建可执行jars的[Maven插件](../VIII. Build tool plugins/58. Spring Boot Maven plugin.md)。

下面是一个典型的pom.xml文件：
```xml
<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <groupId>com.example</groupId>
    <artifactId>myproject</artifactId>
    <version>0.0.1-SNAPSHOT</version>

    <!-- Inherit defaults from Spring Boot -->
    <parent>
        <groupId>org.springframework.boot</groupId>
        <artifactId>spring-boot-starter-parent</artifactId>
        <version>1.3.0.BUILD-SNAPSHOT</version>
    </parent>

    <!-- Add typical dependencies for a web application -->
    <dependencies>
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-starter-web</artifactId>
        </dependency>
    </dependencies>

    <!-- Package as an executable jar -->
    <build>
        <plugins>
            <plugin>
                <groupId>org.springframework.boot</groupId>
                <artifactId>spring-boot-maven-plugin</artifactId>
            </plugin>
        </plugins>
    </build>

    <!-- Add Spring repositories -->
    <!-- (you don't need this if you are using a .RELEASE version) -->
    <repositories>
        <repository>
            <id>spring-snapshots</id>
            <url>http://repo.spring.io/snapshot</url>
            <snapshots><enabled>true</enabled></snapshots>
        </repository>
        <repository>
            <id>spring-milestones</id>
            <url>http://repo.spring.io/milestone</url>
        </repository>
    </repositories>
    <pluginRepositories>
        <pluginRepository>
            <id>spring-snapshots</id>
            <url>http://repo.spring.io/snapshot</url>
        </pluginRepository>
        <pluginRepository>
            <id>spring-milestones</id>
            <url>http://repo.spring.io/milestone</url>
        </pluginRepository>
    </pluginRepositories>
</project>
```
**注**：`spring-boot-starter-parent`是使用Spring Boot的一个不错的方式，但它不总是合适的。有时你需要继承一个不同的parent POM，或者你可能只是不喜欢我们的默认配置。查看[Section 13.1.2, “Using Spring Boot without the parent POM”](../III. Using Spring Boot/13.1.2. Using Spring Boot without the parent POM.md)获取使用import的替代解决方案。
